package ss2010.FritzFritz;
import robocode.*;
import java.awt.*;
import java.io.IOException;
import static robocode.util.Utils.normalRelativeAngleDegrees;

/**
 * TomTom - Leader des Teams FritzFritz
 */
public class TomTom extends TeamRobot {
//Definition der Variable gunTurnAmt
double gunTurnAmt;
/**
	 * run: Bewegungen whrend des Spiels
	 */	
public void run() {
		//Farben
		setColors(Color.black,Color.red,Color.yellow);
		//Sterneform
		while(true) {
			ahead(100);
			turnLeft(45);
			back(100);
			turnLeft(45);
		}	
}
	/**
	 * onScannedRobot: Wenn anderer Roboter gescannt wurde 
	 */	
public void onScannedRobot(ScannedRobotEvent e) {
		// Nicht auf Teammitglied schie§en!
		if (isTeammate(e.getName())) {
			return;
		}
		// Berechnung der feindlichen Richtung
		double enemyBearing = this.getHeading() + e.getBearing();
		// Berechnung der feindlichen Position
		double enemyX = getX() + e.getDistance() * Math.sin(Math.toRadians(enemyBearing));
		double enemyY = getY() + e.getDistance() * Math.cos(Math.toRadians(enemyBearing));

		try {
			// Sender der feindlichen Position an Teammitglied
			broadcastMessage(new Navigon(enemyX, enemyY));
		} catch (IOException ex){}
	
		//Wenn die Entfernung mehr als 500 ist
		if (e.getDistance() > 500) {
			gunTurnAmt = normalRelativeAngleDegrees(e.getBearing() + (getHeading() - getRadarHeading()));
			//Den Roboter drehen und auf die gescannte Postion hin fahren
			turnGunRight(gunTurnAmt); 
			turnRight(e.getBearing());
			ahead(e.getDistance() - 400);
			return;
			}
		//Wenn die Entferung weniger als 200 ist
		if (e.getDistance() < 100) 
			{
			//Prfung ob Richtung nach vorne oder hinten ist.	
			if (e.getBearing() > -90 && e.getBearing() <= 90) 
				{
				back(40);
				} else {
					ahead(40);
					}
			}
		fire(3);				
									
	}	
	/**
	 * onHitRobot: Wenn anderer Roboter gerammt wurde  
	 */
public void onHitRobot(HitRobotEvent e) {
		// Wenn er vor uns ist, zurck fahren
		if (e.getBearing() > -90 && e.getBearing() < 90) {
			back(100);
		} // ansonsten, wenn er hinter uns ist, vorwrts fahren
		else {
			ahead(100);
		}
	}
/**
	 * onHitByBullet: Wenn von einer Kugel getroffen  
	 */
public void onHitByBullet(HitByBulletEvent e) {
		//In die entgegengesetzte Richtng drehen und vorwrts fahren
		turnLeft(90 - e.getBearing());
		ahead(100);
	}
/**
	 * onHitWall: Wenn eine Mauer gerammt wurde  
	 */
public void onHitWall(HitWallEvent e) {
		//In die entgegengesetzte Richtung drehen und vorwrts fahren
		turnLeft(90 - e.getBearing());
		ahead(100);
	} 			
}		
