package ss2010.Hulk;
import java.awt.Color;
import robocode.*;
import robocode.util.Utils;
import static robocode.util.Utils.normalRelativeAngleDegrees;

/**
 * Hulk - ein Robot von Thomas Vogt, Daniel Knerr und Patrick Stephan
 */
public class Hulk extends TeamRobot {
	double hitTime;
	/**
	 * run: Hulk's Standardverhalten
	 */
	public void run() {
		// Hulk wird in schlichtem schwarz/weiß lackiert
		setBodyColor(Color.black);
		setGunColor(Color.white);
		setRadarColor(Color.black);
		setBulletColor(Color.red);
		setScanColor(Color.black);
		
		// Die Gun wird bis in die Unendlichkeit nach rechts gedreht
		while (true) {
			turnGunRight(Double.POSITIVE_INFINITY);
			execute();
		}				
	}

	/**
	 * onScannedRobot: Was Hulk ausführt sobald er einen anderen Robot sieht
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		// Zur Zielberechnung wird das freie Code-Snippet "NarrowLock" vom RoboWiki verwendet
		double radarTurn =getHeadingRadians() + e.getBearingRadians() - getRadarHeadingRadians();
		// setTurnGunRightRadians(Utils.normalRelativeAngle(radarTurn));
		
		// Ist der gescannte Robot unser Teammate?
		if(teammate(e.getName())){
			// Ja, weiter scannen
			return;
		}	
		else{
			// Nein, Schussstärke berechnen und schießen
			fire(getBulletPower(e.getDistance()));
		}
		// Hulk führt mit Hilfe der Zufallsvariable "randomizer" ein Ausweichmanöver nach rechts bzw. links aus
		double randomizer=Math.random()*2;
		if(randomizer<=1){
			setTurnRight(45);
			setAhead(50);
		}
		else{
			setTurnLeft(45);
			setAhead(50);	
		}
	}
	/**
	 * onHitByBullet: Was Hulk ausführt wenn er getroffen wird
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		// Der Name ist Programm, Hulk wird grün und er beschwert sich lautstark
		setBodyColor(Color.green);
		setGunColor(Color.black);
		setRadarColor(Color.green);
		setBulletColor(Color.green);
		setScanColor(Color.green);
		out.println("Ich bin grün und jetzt knallts!");
	}

	/**
	 * onHitWall: Was Hulk ausführt wenn er gegen eine Wand fährt
	 */
	public void onHitWall(HitWallEvent e){
		out.println("Ups, hier gehts nicht weiter");
		
		// Die Ausweichroutine "avoiding()" wird aufgerufen
		avoiding();	
	}

	/**
	 * onHitRobot: Was Hulk ausführt wenn er gegen einen Robot fährt
	 */
	public void onHitRobot(HitRobotEvent e){
		out.println("Aus dem Weg!");
		
		// Die Ausweichroutine "avoiding()" wird aufgerufen
		avoiding();
	}
	
	/**
	 * onWin: Was Hulk ausführt wenn er gewinnt
	 */
	public void onWin(WinEvent e){
		// Hulk freut sich wie ein Schnitzel und....
		// ... färbt sich in den deutschen Nationalfarben ...
		setBodyColor(Color.black);
		setGunColor(Color.red);
		setRadarColor(Color.yellow);
		setBulletColor(Color.red);
		setScanColor(Color.yellow);
		execute();
		// ... dreht sich wie wild im Kreis ...
		turnLeft(3600);
		// ... und freut sich
		out.println("Sieg!");
	}

	/**
	 * getBulletPower: Hulk's Schussstärkenberechnung
	 */
	double getBulletPower(double distance){
		// Je näher der Gegner ist, desto fester schießt Hulk
		if (distance<150)return(3); else
		if (distance<200)return(2.5); else
		if (distance<250)return(2); else
		if (distance<300)return(1.5); else
		return (1);
	}

	/**
	 * avoiding: Hulk's Ausweichroutine
	 */
	public void avoiding(){
		// Zunächst wird die aktuelle Spielzeit genommen
		hitTime=getTime();
		// Nun probiert Hulk nach links auszuweichen
		if(getTime()<hitTime+5){
			turnLeft(111);
			ahead(100);
		}
		// Klappt das nach 5 Zeiteinheiten nicht, so probiert Hulk es nach rechts
		else{
			turnRight(111);
			ahead(100);
		}
	}
	
	/**
	 * teammate: Hulk's Ersatzroutine für isTeamMate
	 */
	public boolean teammate(String name){
		if(name.equals("ss2010.Hulk.BruceBanner"))return true;
		if(name.equals("ss2010.Hulk.BruceBanner*"))return true;
		else return false;	
	}	
}
