package ss2010.KnockoutBombers;
import robocode.*;
import java.awt.Color;

public class Bombertwo extends TeamRobot
{

	public class ColorEngine {
		public  void change(double energie, TeamRobot robot) {
	 		//ist Endergie größer 60 --> alles grün einfärben
		if(energie >= 60)
 			robot.setAllColors(Color.green);
 		//ist Energie zwischen 59 und 40 --> alles gelb einfärben
		else if(energie <=59 && energie >= 40)
 			robot.setAllColors(Color.yellow);
		//ist Energie unter 40 --> alles rot einfärben
		else if(energie <=39 && energie >= 0)
			robot.setAllColors(Color.red);
		}
	}
	// ColorEngine Instanz für die farbliche Abstimmung
	ColorEngine colorengine = new ColorEngine();
	
	// Zustandsvariable, steuert den aktuellen Zustand
	// 0 - Leeerlauf
	// 1 - Suchen
	// 2 - Fixieren
	int Zustand = 1;
	// Steuert den wechsel von Radar drehen nach rechts und links
	boolean turnGunRight = true;
	// Zum speichern des Namens des momentanen Ziels
	String trackName;
	// Dauer für das Zurücklegen der Bullet bis zum Ziel  
	double hitCounter = 1000;	
	// Steuert das Wechseln zwischen links und rechtskurve im Suchen Zustand
	boolean leftTurn = false;
	// Entfernung zum Ziel
	double targetDistance = 0;
	// Geschwindigkeit einer Kugel, angenommen und etwas niedriger angesetzt
	double bulletVelocity =8;
	// dynamische Schussstärke, wird Situationsbedingt angepasst.
	int firePower = 1;

	
	public void run() {
		setAllColors(Color.green);
		//Schleife
		while(true) {
			//Über switch case Auswertung der Zustandsvariable wird der 
			//Automat ausgelöst.
			switch (Zustand){
				case 0: 
					leerlauf();
					break;
				case 1:
					setRadarColor(new Color(0,0,255)) ;
					suche();
					break;
				case 2:
					setRadarColor(new Color(255,0,0)) ;
					fixiere();
					break;
				default:
					System.out.println("Ungueltiger Zustand");
					break;
			}
		}
	}
	public void leerlauf (){	
	}
	public void suche (){
	// Bewegung um nicht getroffen zu werden
		if(leftTurn){
			setTurnLeft(180);
		}
		else{
			setTurnRight(180);
		}
		setAhead(30);
		//gleichzeitig scannen nach Gegnern
		if(turnGunRight){
			setTurnRadarLeft(45);
		}
		else{
			setTurnRadarRight(45);
		}
		execute();
	}
	public void fixiere (){
		//nur feuern wenn die vorhergegangen Schüsse getroffen haben
		hitCounter--;	
		if(hitCounter > 0)
		{
			fire(firePower);
		}
		else{
			//treffe nicht mehr, zurück in Zustand suche
			Zustand =1;
			firePower=1;
		}	
	}	
	public void onScannedRobot(ScannedRobotEvent e) {
		//prüfe ob Teammate
		if (e.getName().equals("ss2010.KnockoutBombers.Bomberone*")){
			
			return;
		}
		else{
			//Ignoriere alle Ziele weiter 600
			if(e.getDistance() < 600)
			{
				stop();
				targetDistance = e.getDistance();
				clearAllEvents();
				// Unabhängige Steuerung von Kanone und Robot
				setAdjustGunForRobotTurn(true); 
				//Berechne Winkel zu Gegner, Richte Kanone aus.
				double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
				setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()));
				setTurnRadarLeft(0);
				//Wechsel in Zustand fixiere
				Zustand=2;
				//Berechne Dauer für Kugel bis sie Ziel treffen müßte
				hitCounter = targetDistance / bulletVelocity;	
				//Prüfe ob Ziel in direkte nähe, wenn ja volle Power				
				if(e.getDistance()<150)
					firePower=15;	
			}
		}	
	}
	public void onRobotDeath(RobotDeathEvent event) 
	{	// Prüfe ob mein momentanes Ziel gerade gestorben ist
		if(trackName.equals(event.getName())){
			// Ziel tot, wechsel in Zustand Suche
			trackName = null;
			Zustand = 1;
			firePower = 1;
		}		
	}
	public void onBulletMissed(BulletMissedEvent e){
		colorengine.change(getEnergy(),(TeamRobot)this);
		Zustand=1;
		firePower=1;
	}
	public void onHitWall(HitWallEvent event) {
		colorengine.change(getEnergy(),(TeamRobot)this);
		turnLeft(event.getBearing());
		ahead (500);
		if(event.getBearing() > 0)
			leftTurn =! leftTurn;
		Zustand = 1;
		firePower = 1;
	}
	public void onBulletHit(BulletHitEvent event){
		colorengine.change(getEnergy(),(TeamRobot)this);
		//Berechne Dauer für Kugel bis sie Ziel treffen müßte
		hitCounter = targetDistance / bulletVelocity;
		// Merke momentanes Ziel
		trackName = event.getName();
		// Inkrementiere Schussstärke wenn getroffen wird
		firePower++;		
	} 
	public void onHitByBullet(HitByBulletEvent e) {
		colorengine.change(getEnergy(),(TeamRobot)this);
	}
}
									
