package ss2010.MadeInChina;
import robocode.*;
import java.awt.*;
import java.io.IOException;
import static robocode.util.Utils.normalRelativeAngleDegrees;

/**
 * C3PO - a robot by (Haze)
 */
public class C3PO extends TeamRobot
{
	int noTarget = 0, noAnswer = 0, counter = 0;	// Zählt wie lange kein Ziel gesichtet wurde
	String target = null, needTarget = "1";			// Merkt sich das Ziel
	
	/**
	 * run: C3PO's default behavior
	 */
	public void run() 
	{
		setColors(Color.black,Color.red,Color.yellow);
		setAdjustRadarForRobotTurn(true);	// Radar und Robot drehen sich unabhängig voneinander
		setAdjustGunForRobotTurn(true);		// Gun und Robot drehen sich unabhängig voneinander
		setAdjustRadarForGunTurn(true);		// Radar und Gun drehen sich unabhängig voneinander
		
		while(true) 
		{	
			turnRadarRight(360);
			noTarget++;						// Zählt wie lange kein Ziel gesichtet wurde
			
			if (noTarget >= 2)
			{
				target = null;				// Länger als 2 Züge ohne Target = neues Target
				noTarget = 0;
				needTarget = "1";
			}
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) 
	{
		chDirCheck(e);
		WallSystem.dir((TeamRobot)this,e,counter);	// Startet WallSystem (näheres dazu in der Klasse selbst)
		
		if (noAnswer >= 3)					// Wenn R2D2 öfter als 3 mal keine Antwort gesendet hat selbst ein Ziel suchen.
		{
			target = e.getName();
		}
		
		if (e.getName().equals("ss2010.MadeInChina.R2D2") || e.getName().equals("ss2010.MadeInChina.R2D2*"))	// Don't fire on teammates
		{
			return;
		}
			else if (e.getName().equals(target) || target == null)
			{
				if (target == null)
				{	
					try
					{
						out.println("Erbitte Ziel!");
						sendMessage("ss2010.MadeInChina.R2D2",needTarget); // Sende gemeinsames Ziel
						needTarget = "0";
						noAnswer ++;								// Hochzählen wie lange keine Antwort von R2D2 kommt
					}
						catch(IOException ex)
						{ 
							out.println("Fehler beim senden!"+getName()); // Abfangen von eventuellen Fehlern 
						}			
				}
					else if (e.getName().equals(target))
					{
						WeaponSystem.tar((TeamRobot)this,e);		// Startet WeaponSystem (näheres dazu in der Klasse selbst)
						
						if (noAnswer <3)
						{
							MovementSystem.def((TeamRobot)this,e);		// Startet MovementSystem (näheres dazu in der Klasse selbst)
						}
							else if (noAnswer >= 3)
							{
								MovementSystem.off((TeamRobot)this,e);
							}

						chDirCheck(e);
						WallSystem.dir((TeamRobot)this,e,counter);
					}
			}			
	}

	public void onHitWall(HitWallEvent e)		// Wenn wir eine Wand rammen
	{	
		MovementSystem.chDir();
	}
	
	public void onMessageReceived(MessageEvent e) 
	{		
		noAnswer = 0;
		out.println("Sie haben Post!");
		target = (String) e.getMessage();		// Zuweisen des neu erhaltenen Ziels
		out.println("R2D2 sagt: Neues Ziel ist " + target + "!");
	}

	public void onHitRobot(HitRobotEvent e)
	{
		MovementSystem.chDir();
	}

	public void chDirCheck (ScannedRobotEvent e)
	{
		if (WallSystem.wallDistance((TeamRobot)this,e) == true)
		{
			out.println("Drehe um");
			counter = 1;
		}
			else if (WallSystem.wallDistance((TeamRobot)this,e) == false)
			{
				out.println("Drehe nicht um");
				counter = 0;
			}
	}
}
